/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CDialog.h,v 1.2 1999/09/17 04:20:47 nryan Exp $
____________________________________________________________________________*/

#ifndef Included_CDialog_h	// [
#define Included_CDialog_h

#include "pgpClassesConfig.h"

#include <prsht.h>
#include "CWindow.h"

_PGP_BEGIN

// Class CDialog

class CDialog : public CWindow
{
private:
	enum
	{
		DialogMapSize	= 100, 
		IDDialogError	= 0x4242
	};

public:
	CDialog() { }
	CDialog(HWND hWnd) : CWindow(hWnd) { }
	~CDialog() { }

	virtual PGPUInt16	GetDialogId() const = 0;

	PGPBoolean	MapDialogRect(RECT& rect) const
	{
		return ::MapDialogRect(Handle(), &rect);
	}

	PGPUInt32	VertDLUToPixel(PGPUInt32 dlus) const
	{
		return (dlus * mBaseUnitY) / 8;
	}

	PGPUInt32	HorizDLUToPixel(PGPUInt32 dlus) const
	{
		return (dlus * mBaseUnitX) / 4;
	}

	PGPUInt32	VertPixelToDLU(PGPUInt32 pixels) const
	{
		return (pixels * 8) / mBaseUnitY;
	}

	PGPUInt32	HorizPixelToDLU(PGPUInt32 pixels) const
	{
		return (pixels * 4) / mBaseUnitX;
	}

	void	RectPixelToDLU(RECT& rect) const;
	void	RectDLUToPixel(RECT& rect) const;

	PGPInt32	CreateModal(HWND parent);
	void		CreateNonModal(HWND parent);
	void		DestroyDialog();

protected:
	void	CreateAsPropPage(PROPSHEETPAGE& psp, HPROPSHEETPAGE& pageHandle);

	void	EndModalDialog(PGPInt32 result = IDOK);
	void	EndModalDialog(CComboError error);
	void	EndNonModalDialog();

private:
	PGPBoolean	mIsModal;
	CComboError	mError;

	PGPUInt32	mBaseUnitX;
	PGPUInt32	mBaseUnitY;

	PGPUInt32	mPixelMarginControl;
	PGPUInt32	mPixelMarginDialog;

	// Class utility functions.

	void	CalcBaseUnits();
	void	HandleWindowError(CComboError error);

	// Dialog procedure functions.

	static BOOL CALLBACK	GlobalDialogProc(HWND hWnd, UINT uMsg, 
		WPARAM wParam, LPARAM lParam);

	static BOOL CALLBACK	PropPageStub(HWND hWnd, UINT uMsg, 
		WPARAM wParam, LPARAM lParam);

protected:
	// Dialog message handlers.
	virtual void	OnCancel();
	virtual void	OnOk();

	BOOL			OnCommand(PGPUInt16 notifyCode, PGPUInt16 itemId, 
		HWND ctrl);
	virtual BOOL	OnInitDialog(HWND focusCtrl);
};

_PGP_END

#endif	// ] Included_CDialog_h
